/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Objects;
import java.util.UUID;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedLanternBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class WallLanternBlockTile
extends EnhancedLanternBlockTile
implements IBlockHolder,
IOwnerProtected {
    public static final ModelProperty<BlockState> MIMIC = BlockProperties.MIMIC;
    private BlockState mimic = Blocks.f_50681_.m_49966_();
    public boolean isRedstoneLantern = false;
    private UUID owner = null;

    public WallLanternBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.WALL_LANTERN_TILE.get(), pos, state);
    }

    @Override
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.getHeldBlock()).withInitial(FANCY, (Object)this.shouldHaveTESR).build();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState oldMimic = this.mimic;
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (!Objects.equals(oldMimic, this.mimic)) {
            ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setHeldBlock(NbtUtils.m_129241_((CompoundTag)compound.m_128469_("Lantern")));
        this.isRedstoneLantern = compound.m_128471_("IsRedstone");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Lantern", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        compound.m_128379_("IsRedstone", this.isRedstoneLantern);
    }

    @Override
    public BlockState getHeldBlock(int index) {
        return this.mimic;
    }

    @Override
    public boolean setHeldBlock(BlockState state, int index) {
        if (state.m_61138_((Property)LanternBlock.f_153459_)) {
            state = (BlockState)state.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false));
        }
        this.mimic = state;
        int light = state.m_60791_();
        boolean lit = true;
        if (this.mimic.m_60734_().getRegistryName().toString().equals("charm:redstone_lantern")) {
            this.isRedstoneLantern = true;
            light = 15;
            lit = false;
        }
        if (this.f_58857_ != null && !this.mimic.m_60795_()) {
            VoxelShape shape = state.m_60808_((BlockGetter)this.f_58857_, this.f_58858_);
            if (!shape.m_83281_()) {
                this.attachmentOffset = shape.m_83215_().f_82292_ - 0.5625;
            }
            if ((Integer)this.m_58900_().m_61143_((Property)WallLanternBlock.LIGHT_LEVEL) != light) {
                this.m_58904_().m_7731_(this.f_58858_, (BlockState)((BlockState)this.m_58900_().m_61124_((Property)WallLanternBlock.LIT, (Comparable)Boolean.valueOf(lit))).m_61124_((Property)WallLanternBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 20);
            }
        }
        return true;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    static {
        maxSwingAngle = 45.0f;
        minSwingAngle = 1.9f;
        maxPeriod = 28.0f;
        angleDamping = 80.0f;
        periodDamping = 70.0f;
    }
}

